// Copyright  2002 Charlie Poole. All rights reserved.
using System;
using EnvDTE;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace NUnit.Wizards
{
	/// <summary>
	/// Summary description for TestFixtureOptionsForm.
	/// </summary>
	public class TestFixtureOptionsForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.TextBox teardownMethodTextBox;
		private System.Windows.Forms.TextBox setupMethodTextBox;
		private System.Windows.Forms.CheckBox teardownCheckBox;
		private System.Windows.Forms.CheckBox setupCheckBox;
		private System.Windows.Forms.Button cancelButton;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button helpButton;
		private System.Windows.Forms.Button finishButton;
		private System.Windows.Forms.Button backButton;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private CSharpAddTestFixtureWiz wizard;

		private TestFixtureGenerator generator;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label projectNameLabel;
		private System.Windows.Forms.Label fixtureNameLabel;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox testPrefixTextBox;
		private System.Windows.Forms.TextBox testSuffixTextBox;
		private bool initialLoad = true;

		public TestFixtureOptionsForm( CSharpAddTestFixtureWiz wizard ) : base ()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			this.wizard = wizard;
			this.generator = wizard.Generator;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.teardownMethodTextBox = new System.Windows.Forms.TextBox();
			this.setupMethodTextBox = new System.Windows.Forms.TextBox();
			this.teardownCheckBox = new System.Windows.Forms.CheckBox();
			this.setupCheckBox = new System.Windows.Forms.CheckBox();
			this.cancelButton = new System.Windows.Forms.Button();
			this.helpButton = new System.Windows.Forms.Button();
			this.finishButton = new System.Windows.Forms.Button();
			this.backButton = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.projectNameLabel = new System.Windows.Forms.Label();
			this.fixtureNameLabel = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.testPrefixTextBox = new System.Windows.Forms.TextBox();
			this.testSuffixTextBox = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.groupBox2.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.label3,
																					this.testSuffixTextBox,
																					this.testPrefixTextBox,
																					this.label2,
																					this.teardownMethodTextBox,
																					this.setupMethodTextBox,
																					this.teardownCheckBox,
																					this.setupCheckBox});
			this.groupBox2.Location = new System.Drawing.Point(112, 144);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(392, 200);
			this.groupBox2.TabIndex = 3;
			this.groupBox2.TabStop = false;
			// 
			// teardownMethodTextBox
			// 
			this.teardownMethodTextBox.Location = new System.Drawing.Point(208, 56);
			this.teardownMethodTextBox.Name = "teardownMethodTextBox";
			this.teardownMethodTextBox.Size = new System.Drawing.Size(176, 22);
			this.teardownMethodTextBox.TabIndex = 5;
			this.teardownMethodTextBox.Text = "TearDown";
			// 
			// setupMethodTextBox
			// 
			this.setupMethodTextBox.Location = new System.Drawing.Point(208, 16);
			this.setupMethodTextBox.Name = "setupMethodTextBox";
			this.setupMethodTextBox.Size = new System.Drawing.Size(176, 22);
			this.setupMethodTextBox.TabIndex = 3;
			this.setupMethodTextBox.Text = "Setup";
			// 
			// teardownCheckBox
			// 
			this.teardownCheckBox.Location = new System.Drawing.Point(24, 56);
			this.teardownCheckBox.Name = "teardownCheckBox";
			this.teardownCheckBox.Size = new System.Drawing.Size(360, 24);
			this.teardownCheckBox.TabIndex = 1;
			this.teardownCheckBox.Text = "Include Teardown method";
			this.teardownCheckBox.CheckedChanged += new System.EventHandler(this.teardownCheckBox_CheckedChanged);
			// 
			// setupCheckBox
			// 
			this.setupCheckBox.Location = new System.Drawing.Point(24, 16);
			this.setupCheckBox.Name = "setupCheckBox";
			this.setupCheckBox.Size = new System.Drawing.Size(168, 24);
			this.setupCheckBox.TabIndex = 0;
			this.setupCheckBox.Text = "Include Setup method";
			this.setupCheckBox.CheckedChanged += new System.EventHandler(this.setupCheckBox_CheckedChanged);
			// 
			// cancelButton
			// 
			this.cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cancelButton.Location = new System.Drawing.Point(432, 376);
			this.cancelButton.Name = "cancelButton";
			this.cancelButton.TabIndex = 11;
			this.cancelButton.Text = "Cancel";
			// 
			// helpButton
			// 
			this.helpButton.Location = new System.Drawing.Point(112, 376);
			this.helpButton.Name = "helpButton";
			this.helpButton.TabIndex = 8;
			this.helpButton.Text = "&Help";
			// 
			// finishButton
			// 
			this.finishButton.Location = new System.Drawing.Point(320, 376);
			this.finishButton.Name = "finishButton";
			this.finishButton.TabIndex = 10;
			this.finishButton.Text = "&Finish";
			this.finishButton.Click += new System.EventHandler(this.finishButton_Click);
			// 
			// backButton
			// 
			this.backButton.Location = new System.Drawing.Point(240, 376);
			this.backButton.Name = "backButton";
			this.backButton.TabIndex = 9;
			this.backButton.Text = "<&Back";
			this.backButton.Click += new System.EventHandler(this.backButton_Click);
			// 
			// label1
			// 
			this.label1.BackColor = System.Drawing.SystemColors.Control;
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(40, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(464, 32);
			this.label1.TabIndex = 13;
			this.label1.Text = "Step 2 of 2: Generation Options";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.projectNameLabel,
																					this.fixtureNameLabel,
																					this.label5,
																					this.label4});
			this.groupBox1.Location = new System.Drawing.Point(112, 40);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(392, 96);
			this.groupBox1.TabIndex = 14;
			this.groupBox1.TabStop = false;
			// 
			// projectNameLabel
			// 
			this.projectNameLabel.Location = new System.Drawing.Point(120, 56);
			this.projectNameLabel.Name = "projectNameLabel";
			this.projectNameLabel.Size = new System.Drawing.Size(264, 16);
			this.projectNameLabel.TabIndex = 3;
			// 
			// fixtureNameLabel
			// 
			this.fixtureNameLabel.Location = new System.Drawing.Point(120, 24);
			this.fixtureNameLabel.Name = "fixtureNameLabel";
			this.fixtureNameLabel.Size = new System.Drawing.Size(264, 16);
			this.fixtureNameLabel.TabIndex = 2;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(32, 56);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(64, 16);
			this.label5.TabIndex = 1;
			this.label5.Text = "In Project:";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(32, 24);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(80, 16);
			this.label4.TabIndex = 0;
			this.label4.Text = "Creating:";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(24, 96);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(112, 24);
			this.label2.TabIndex = 6;
			this.label2.Text = "TestCase Prefix:";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// testPrefixTextBox
			// 
			this.testPrefixTextBox.Location = new System.Drawing.Point(144, 96);
			this.testPrefixTextBox.Name = "testPrefixTextBox";
			this.testPrefixTextBox.Size = new System.Drawing.Size(48, 22);
			this.testPrefixTextBox.TabIndex = 7;
			this.testPrefixTextBox.Text = "";
			// 
			// testSuffixTextBox
			// 
			this.testSuffixTextBox.Location = new System.Drawing.Point(336, 96);
			this.testSuffixTextBox.Name = "testSuffixTextBox";
			this.testSuffixTextBox.Size = new System.Drawing.Size(48, 22);
			this.testSuffixTextBox.TabIndex = 8;
			this.testSuffixTextBox.Text = "";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(216, 96);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(112, 24);
			this.label3.TabIndex = 9;
			this.label3.Text = "TestCase Suffix:";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// TestFixtureOptionsForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(520, 416);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.groupBox1,
																		  this.label1,
																		  this.cancelButton,
																		  this.helpButton,
																		  this.finishButton,
																		  this.backButton,
																		  this.groupBox2});
			this.Name = "TestFixtureOptionsForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "CSharp TestFixture Wizard";
			this.Load += new System.EventHandler(this.Form_Load);
			this.groupBox2.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void Form_Load(object sender, System.EventArgs e)
		{
			if ( initialLoad )
			{
				fixtureNameLabel.Text = wizard.ItemName;
				projectNameLabel.Text = wizard.ProjectName;

				bool notEmptyFixture = generator.FixtureType != TestFixtureType.EmptyFixture;
				
				setupCheckBox.Checked = notEmptyFixture;
				teardownCheckBox.Checked = notEmptyFixture;
				setupMethodTextBox.Enabled = notEmptyFixture;
				teardownMethodTextBox.Enabled = notEmptyFixture;

				setupMethodTextBox.Text = "SetUp";
				teardownMethodTextBox.Text = "TearDown";

				testPrefixTextBox.Enabled = notEmptyFixture;
				testSuffixTextBox.Enabled = notEmptyFixture;

				testPrefixTextBox.Text = "";
				testSuffixTextBox.Text = "Test";

				initialLoad = false;
			}
		}

		private void setupCheckBox_CheckedChanged(object sender, System.EventArgs e)
		{
			setupMethodTextBox.Enabled = setupCheckBox.Checked;
		}

		private void teardownCheckBox_CheckedChanged(object sender, System.EventArgs e)
		{
			teardownMethodTextBox.Enabled = teardownCheckBox.Checked;
		}

		private void finishButton_Click(object sender, System.EventArgs e)
		{
			generator.SetupMethod = setupCheckBox.Checked;
			generator.TeardownMethod = teardownCheckBox.Checked;
			generator.SetupMethodName = setupMethodTextBox.Text;
			generator.TeardownMethodName = teardownMethodTextBox.Text;

			generator.TestCasePrefix = testPrefixTextBox.Text;
			generator.TestCaseSuffix = testSuffixTextBox.Text;

			wizard.Result = wizardResult.wizardResultSuccess;
			this.Close();									   
		}

		private void backButton_Click(object sender, System.EventArgs e)
		{
			wizard.Result = wizardResult.wizardResultBackOut;
			this.Close();
		}
	}
}
